--
-- file prepared: 15 May 2024 23:19:08.053, using fd633c
--
--SFM_heading.lua (file 1 for assembly)

dofile(current_mod_path.."/Views.lua")

p38 = {

	Name = 'p38',
	DisplayName = _('p38'),

	EmptyWeight = 5806,
	MaxFuelWeight = 1250,
	MaxHeight = 13411,
	MaxSpeed = 719,
	MaxTakeOffWeight = 9798,
	Picture = "p38.png",
	Rate = 20, 

	WingSpan = 15.85,
	WorldID = p38,
	defFuelRatio = 0.68,

	country_of_origin = "USA",

	Shape = "p38",
	propellorShapeType = "3ARG_PROC_BLUR",
	propellorShapeName = "P-51D_blade.FBX",
	shape_table_data =
	{
		{
			file = 'p38';
			life = 18;
			vis = 3;
			--desrt = "p51-oblomoki";
			fire = { 300, 2};
			username = 'p38';
			index = p38;
			drawonmap = true;
		},
	},
	------------------------ -
--(file 2 for aessembly)

	mapclasskey = "P0091000026",
	attribute = { wsType_Air, wsType_Airplane, wsType_Fighter, P38, "Battleplanes" },

--SFM_characteristics.lua (file 3 for assembly)

	---------	General	Characteristics	---------
	length = 11.53,
	height = 3.91,
	wing_area = 30.43,
	wing_span = 15.85,
	wing_tip_pos = { 1.75, 0.6, 7.5},
	RCS = 2.8,											--(estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 5806,
	M_nominal = 7938,
	M_max = 9798,
	M_fuel_max = 1250,
	H_max = 13411,										-- (calculated from service_ceiling)
	CAS_min = 36,
	average_fuel_consumption = 0.302,					-- default 

	----------_ AI Flight Parameters -----------
	V_opt = 147,
	V_take_off = 37,
	V_land = 37,
	V_max_sea_level = 104,
	V_max_h = 92,
	Vy_max = 42,										-- note: default calculation override for p38
	Mach_max = 0.598,
	Ny_min = -3,										-- default
	Ny_max = 6,											-- default (wwii era, restricted maneuverability)
	Ny_max_e = 6,										-- default (wwii era, restricted maneuverability)
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 3.25, -1.25, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { 1.25, -1.25, 2.25},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 1753.9,
	thrust_sum_ab = 1753.9,
	engines_count = 2,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			pilot_name = 56,
			ejection_seat_name = 0,
			drop_canopy_name = "aircraft_canopy", 
			pos = {3.25, -0.3, 0},
			canopy_pos = {3.25, -0.3, 0},
			drop_parachute_name = "pilot_parachute",
		}, --end of[1]
	}, --end of crew_members


---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {3.5, 0.23, 2.3},
			elevation = 0.23,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
		}, -- end of [1]
		[2] =
		{
			pos = {3.5, 0.23, -2.3},
			elevation = 0.23,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		M_2({ muzzle_pos = {0.4, 0.2, 0.4},_connector =  "Point_Gun_01",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_2({ muzzle_pos = {0.75, 0.28, 0.1},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_2C({ muzzle_pos = {0.75, 0.18, 0},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_2({ muzzle_pos = {0.75, 0.28, -0.1},_connector =  "Point_Gun_04",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_2({ muzzle_pos = {0.4, 0.2, -0.4},_connector =  "Point_Gun_05",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 1.25, 0.3, 4.5, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(4, 0, 1.5, -0.1, 1.25, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(5, 0, 1.5, -0.1, -1.25, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(6, 0, 1.25, 0.3, -4.5, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},



---------------------------------------------------------------------------------------------------------------------------------------------


	fires_pos =
	{
		[1] = { 0.875, 0.6, 0.0},
		[2] = { 0.35, 0.6, 0.1},
		[3] = { 0.525, 0.6, -0.1},
		[4] = { 1.5, 0.6, 1.875},
		[5] = { 1.5, 0.6, -1.875},
		[6] = { 1.5, 0.6, 6},
		[7] = { 1.5, 0.6, -6},
		[8] = { 3.5, 0.23, 0.1},
		[9] = { 3.5, 0.23, -0.1},
		[10] = { 1.75, 0.6, 0.1},
		[11] = { 1.75, 0.6, -0.1},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------
-- (file 4 for assembly)

	--[[
	fires_pos = 
	{
		[1] = 	{-2,	0.595,	0.5},
		[2] = 	{0,	0,	2.237},
		[3] = 	{0,	0,	-2.237},
		[4] = 	{0.265,	0,	1.5},
		[5] = 	{-0.265,	0,	-1.5},
		[6] = 	{0.5,	0,	4.274},
		[7] = 	{0.5,	0,	-4.274},
		[8] = 	{-5,	0.5,	0},
		[9] = 	{-5,	0.5,	0},
		[10] = 	{-5,	0.5,	0},
		[11] = 	{-5,	0.5,	0},
	}, -- end of fires_pos
	]]--

	--[[
    mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "at", 0.11111111111111},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "at", 0.16666666666667},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"TearCanopy", 0},},},},},
        },
    },
	]]--

	net_animation = { 420 --[[external_model_throttle_arg]]},
	
	detection_range_max		 = 0,
	radar_can_see_ground 	 = false, 
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_BAD, LOOK_GOOD, LOOK_GOOD),

	--[[
	Sensors = {
		OPTIC = "Merkury LLTV", -- For night goggles imitation
   	},
	]]--

	--[[
	HumanRadio = {
			frequency = 124.0,
			editable = true,
			minFrequency = 100.000,
			maxFrequency = 156.000,
			modulation = MODULATION_AM
	},
	]]--
	
	Tasks ={
        aircraft_task(Reconnaissance),
	    aircraft_task(CAP),                 
        aircraft_task(CAS),                 
        aircraft_task(SEAD),                
        aircraft_task(GroundAttack),        
        aircraft_task(AFAC),                
        aircraft_task(RunwayAttack),
        aircraft_task(AntishipStrike),
        aircraft_task(Refueling),           
    },
	DefaultTask = aircraft_task(CAP),
	
	--SFM_aerodynamics.lua (file 5 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.119,	0.0473,	0.00346,	2.12,	14.5,	1.73,		},
				{0.0925,	0.015,	0.123,	0.0473,	0.00346,	2.57,	14,	1.73,		},
				{0.185,	0.015,	0.125,	0.0473,	0.00346,	3.12,	15.4,	1.93,		},
				{0.277,	0.015,	0.0751,	0.02,	0.00127,	3.79,	19.1,	2,		},
				{0.37,	0.015,	0.0818,	0.0101,	0.00054,	4.61,	19.1,	2,		},
				{0.463,	0.015,	0.0896,	0.00512,	0.000227,	5.6,	19.1,	2,		},
				{0.555,	0.015,	0.0983,	0.00257,	0.00016,	4.9,	19.1,	2,		},
				{0.647,	0.015,	0.0983,	0.814,	0.407,	4.07,	19.1,	2,		},
				{0.74,	0.0575,	0.103,	0.677,	0.338,	3.38,	18.2,	1.91,		},
				{0.833,	0.0675,	0.108,	0.563,	0.281,	2.81,	17.4,	1.82,		},
				{0.925,	0.0775,	0.113,	0.468,	0.234,	2.34,	16.6,	1.74,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 23.0,					-- default 
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 1,
			ForsRUD  = 1,
			typeng  = 2,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,
			k_adiab_1 = 0.037923,					-- default 
			k_adiab_2 = 0.0562,						-- default 
			MAX_Manifold_P_1 = 155774,				-- default 
			MAX_Manifold_P_2 = 206570,				-- default 
			MAX_Manifold_P_3 = 226648,				-- default 
			k_after_cool = 0.54,					-- default 
			Displ = 27,								-- default 
			k_Eps = 6,								-- default 
			Stroke = 0.152,							-- default 
			V_pist_0 = 12,							-- default 
			Nu_0 = 1.2,								-- default 
			Nu_1 = 0.9,								-- default 
			Nu_2 = 0.001,							-- default 
			N_indic_0 = 1023040,					-- default 
			N_fr_0 = 0.072,							-- default 
			N_fr_1 = 0.02,							-- default 
			Init_Mom = 220,							-- default 
			D_prop = 3.45,							-- default 
			MOI_prop = 65,							-- default 
			k_gearbox = 2.088,						-- default 
			P_oil = 495438,							-- default 
			k_boost = 3,							-- default 
			k_cfug = 0.003,							-- default 
			k_oil = 0.00004,						-- default 
			k_piston = 3000,						-- default 
			k_reg = 0.003,							-- default 
			k_vel = 0.017,							-- default 
			--[[
			table_data = {
				--M 	Pmax
				{0,	8589	},
				{0.2,	12884	},
				{0.4,	17179	},
				{0.6,	17179	},
				{0.8,	17179	},
				{1,	17179	},
				{1.2,	17179	},
				{1.4,	17179	},
				{1.6,	17179	},
				{1.8,	17179	},
				{2,	12884	},
				{2.2,	8589	},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				25 k ft		0.m		adj:+/-
				26 k ft		0.m		adj:+/-
				35 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
				44 k ft		0.m		adj:+/-
				46 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 7619, 8000, 10954, 12324, 13419, 14035 }, 
					thrust = {
						{ 17194,  25792,  34389,  34389,  34389,  34389,  34389,  34389,  34389,  34389,  25792,  17194  }, 
						{ 8590,   12885,  17181,  17181,  17181,  17181,  17181,  17181,  17181,  17181,  12885,  8590   }, 
						{ 5718,   8578,   11437,  11437,  11437,  11437,  11437,  11437,  11437,  11437,  8578,   5718   }, 
						{ 5361,   8042,   10722,  10722,  10722,  10722,  10722,  10722,  10722,  10722,  8042,   5361   }, 
						{ 3438,   5158,   6877,   6877,   6877,   6877,   6877,   6877,   6877,   6877,   5158,   3438   }, 
						{ 3438,   5158,   6877,   6877,   6877,   6877,   6877,   6877,   6877,   6877,   5158,   3438   }, 
						{ 2579,   3868,   5158,   5158,   5158,   5158,   5158,   5158,   5158,   5158,   3868,   2579   }, 
						{ 429,    644,    859,    859,    859,    859,    859,    859,    859,    859,    644,    429    }, 
					}, -- thrust = {

				}, --thrust_max = {

			}, -- extended = {

			Startup_Prework = 15.0,					-- default 
			Startup_RPMs = {						-- default 
				{0.0, 0},							-- default 
				{1.0, 60},							-- default 
				{7.0, 60},							-- default 
				{9.0, 400},							-- default 
				{11.0, 880},						-- default 
				{15.0, 550},						-- default 
			},
			Startup_Ignition_Time = 8.0,			-- default 
			Shutdown_Duration = 9.8,				-- default 
			Nominal_RPM = 3000.0,					-- default 
			prop_pitch_min = 23.0,					-- default 
			prop_pitch_max = 65.0,					-- default 
			prop_pitch_feather = 80.0,				-- default 
			prop_blades_count = 4,					-- default 
			prop_locations = {
				{ 4, 0.15, 2.8}, {0.0, 0.0, math.rad(-1.87)},
				{ 4, 0.15, -2.8}, {0.0, 0.0, math.rad(-1.87)},
			},

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "p38-collision",
	},

-- (file 6 for aessembly)

	Damage = {
		[11]		= {critical_damage = 3, args = {147}}, -- engine l
		[39]		= {critical_damage = 4, args = {242}}, -- fin top left
		[43]		= {critical_damage = 6, args = {243}, deps_cells = {39, 54, 45, 46, 49, 50}}, -- fin bottom left
		[54]		= {critical_damage = 3, args = {247}}, -- rudder right
		[45]		= {critical_damage = 4, args = {235}}, -- stabilizer out left
		[47]		= {critical_damage = 6, args = {236}, deps_cells = {49}} ,-- stabilizer in left
		[46]		= {critical_damage = 4, args = {233}}, -- stabilizer out right
		[48]		= {critical_damage = 6, args = {234}, deps_cells = {50}}, -- stabilizer in right
		[49]		= {critical_damage = 3, args = {240}},-- elevator out left
		[50]		= {critical_damage = 3, args = {238}},-- elevator out right
		[4]		    = {critical_damage = 5, args = {154}},-- cabin left
		[5]		    = {critical_damage = 5, args = {153}},-- cabin right
		[82]		= {critical_damage = 5, args = {152}},-- fuselage bottom
		[56]		= {critical_damage = 5, args = {158}},-- tail left
		[57]		= {critical_damage = 5, args = {157}},-- tail right
		[55]		= {critical_damage = 7, args = {81}, deps_cells = {43, 54, 45, 46}}, -- tail 
		[3]		    = {critical_damage = 3, args = {296}}, -- cockpit 
		[59]		= {critical_damage = 5, args = {148}}, -- nose bottom 
		[1]		    = {critical_damage = 5, args = {150}}, -- nose left
		[2]		    = {critical_damage = 5, args = {149}}, -- nose right
		[24]		= {critical_damage = 7, args = {213}, deps_cells = {26}},-- wing out right 
		[30]		= {critical_damage = 7, args = {214}, deps_cells = {24, 26, 38}},-- wing center right 
		[36]		= {critical_damage = 7, args = {215}, deps_cells = {30, 24, 26, 38}}, -- wing in right 
		[26]		= {critical_damage = 3, args = {216}}, -- eleron right 
		[38]		= {critical_damage = 4, args = {217}},-- flap in right 
		[23]		= {critical_damage = 7, args = {223}, deps_cells = {25}}, -- wing out left
		[29]		= {critical_damage = 7, args = {224}, deps_cells = {23, 25, 37}}, -- wing center left 
		[35]		= {critical_damage = 7, args = {225}, deps_cells = {29, 23, 25, 37}}, -- wing in left 
		[25]		= {critical_damage = 3, args = {226}}, -- eleron left 
		[37]		= {critical_damage = 4, args = {227}}, -- flap in left 
		[83]		= {critical_damage = 2, args = {134}}, -- wheel nose 
		[85]		= {critical_damage = 3, args = {135}}, -- wheel right 
		[84]		= {critical_damage = 3, args = {136}}, -- wheel left 
		[63]		= {critical_damage = 6, args = {53}, deps_cells = {66, 69, 72, 75}}, -- rotor
		[66]		= {critical_damage = 3, args = {380}}, -- blade 1 out  (for contact model!)
		[69]		= {critical_damage = 3, args = {381}}, -- blade 2 out  (for contact model!)
		[72]		= {critical_damage = 3, args = {382}}, -- blade 3 out  (for contact model!)
		[75]		= {critical_damage = 3, args = {383}}, -- blade 4 out  (for contact model!)
		[64]		= {critical_damage = 3, args = {429}}, -- blade 1 in
		[67]		= {critical_damage = 3, args = {430}}, -- blade 2 in
		[70]		= {critical_damage = 3, args = {431}}, -- blade 3 in
		[73]		= {critical_damage = 3, args = {119}}, -- blade 4 in
	},
	
	--[[
	Failures = {
		{ id = 'HORIZON_BAR_NOT_SETTLE',	  	  label = _('Artificial Horizon'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_FAILS_NO_VACUUM', label = _('Turn ind. No vac.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_FAILS_DEFECTIVE', label = _('Turn ind. defective'),	 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_DEFECTIVE',label = _('Turn ind. Incorrect  sens.'),	 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_VAC_HIGH', label = _('Turn ind. Vacuum high'),		 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_VAC_LOW',  label = _('Turn ind. Vacuum low'),			 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_NOT_SET_ZERO',	  label = _('Turn ind. Pointer does not set on 0(N/F)'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_VIBRATES',	  	  label = _('Turn ind. Pointer vibrates(N/F)'),		 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_SEPARATOR_CLOGGED',	  	  label = _('Vacuum pump separator clogged'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_RELIEF_VALVE_SCREEN_CLOGGED',	label = _('Vacuum valve screen clogged'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_RELIEF_VALVE_LEAKS',	  		label = _('Vacuum relief valve leaks'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_FAILS',	  					label = _('Vacuum pump fails'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MANIFOLD_SHIFT',					label = _('Manifold pressure ind. pointer shifted'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MANIFOLD_LINE_LEAK',				label = _('Manifold pressure ind. line leak'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'COOLANT_RADIATOR_WIRING',		label = _('Coolant radiator flap. No volt.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_RADIATOR_MOTOR',		label = _('Coolant radiator flap. Motor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_RADIATOR_SENSOR',		label = _('Coolant radiator sensor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'OIL_RADIATOR_WIRING',			label = _('Oil radiator flap. No volt.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_RADIATOR_MOTOR',			label = _('Oil radiator flap. Motor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_RADIATOR_SENSOR',			label = _('Oil radiator sensor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_LEAK',						label = _('Oil Leak.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'COMPASS_NO_TORQUE',	  			label = _('Remote Compass. No torque'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_OPERATION',	  	label = _('Remote Compass. Erratic operation'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_POINTER_PULLS',	  		label = _('Remote Compass. Pointer pulls'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_INDIACATON',	label = _('Remote Compass. Loose pointer'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'DEFECTIVE_INSTRUMENT',	  		label = _('Directional gyro fail'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DEFECTIVE_MECHANISM',			label = _('Directional gyro mechanism fail'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'PITOT_HEAT_WIRING',				label = _('Pitot heating wire broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PITOT_HEAT_ELEMENT',			label = _('Pitot heating element burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BAT_SOLENOID_WIRING',			label = _('Bat. solenoid wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BAT_SOLENOID_DEFECTIVE',		label = _('Bat. solenoid defective'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'SUPERCHARGER_LIGHT',		label = _('Supercharger light fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'SUPERCHARGER_WIRE',			label = _('Supercharger wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'SUPERCHARGER_SOLENOID',		label = _('Supercharger solenoid fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_DILUTION_SOLENOID',		label = _('Oil dilution solenoid fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_DILUTION_WIRE',			label = _('Oil dilution wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'TACH_BREAK_CIRCUIT',		label = _('Tachometer circuit break'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_BREAK_IN_INDICATOR',	label = _('Tachometer indicator break'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_POOR_CONNECTION',		label = _('Tachometer poor connection'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_RESISTANCE_ADJ',		label = _('Tachometer indicator adjustment fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'VHF_CRYSTAL',				label = _('Radio. Crystal or tube failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SHORTED_CTL_BOX',		label = _('Radio. Shorted control box'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_VT_BURNED_OUT',			label = _('Radio. Receiver burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_VT207_DEFECTIVE',		label = _('Radio. Squelch tube burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SQUELCH_RELAY',			label = _('Radio. Squelch relay not working'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'F2_TOP_CYLINDER',		label = _('Top oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'F2_BOTTOM_CYLINDER',	label = _('Bottom oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'D2_LEFT_CYLINDER',		label = _('Left oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'D2_RIGHT_CYLINDER',		label = _('Right oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	
		{ id = 'COOLANT_BREAK_BULB',		label = _('Coolant temp. ind. bulb fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_DEFECTIVE_IND',		label = _('Coolant temp. ind. defective'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_POOR_CONNTECT',		label = _('Coolant temp. ind. poor connection'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_SHORT_CIRCUIT',		label = _('Coolant temp. ind. short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'CARBAIR_SHORT_CIRCUIT',		label = _('Carb. air ind. open or short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_SHORT_CIRCUIT_LEADS',label = _('Carb. air ind. short circuit in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_GND_LEAD',			label = _('Carb. air ind. gnd in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_SHORT_CIRCUIT_BLB',	label = _('Carb. air ind. bulb short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_BREAK_LEADS',		label = _('Carb. air ind. breaks in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_OPEN_CIRCUIT_BLB',	label = _('Carb. air ind. open circuit in bulb'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'EXT_HYDRO_LEAK',	  		label = _('External hydro leak'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
        { id = 'INT_HYDRO_LEAK',	  		label = _('Internal hydro leak'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'HYDRO_LOW_AIR_PRESSURE',	label = _('Hydro acc. low air pressure'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'UNLOAD_VALVE_NOT_LOAD',	  	label = _('Hydro relief valve stuck in unload'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'UNLOAD_VALVE_NOT_UNLOAD',	label = _('Hydro relief valve stuck in load'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	
		{ id = 'MAIN_L_GEAR_D_LOCK',	label = _('Left gear downlock fail'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAIN_R_GEAR_D_LOCK',	label = _('Right gear downlock fail'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_D_LOCK',		label = _('Tail gear downlock fail'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_U_LOCK',		label = _('Tail gear lock spring broken'), 	  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_FAIL_GO_DOWN',label = _('Tail gear up-latch cable broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_FAIL_GO_UP',	label = _('Tail gear down-lock cable broken'),enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_C_CABLE',		label = _('Tail gear cable jammed'), 		  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'L_GEAR_UPL_FAULT',		label = _('Left gear up-latch locked'),	 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'R_GEAR_UPL_FAULT',		label = _('Right gear up-latch locked'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'L_GEAR_DLK_FAULT',		label = _('Left gear down-lock locked'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'R_GEAR_DLK_FAULT',		label = _('Right gear down-lock locked'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DOORS_TV_JAMMED',		label = _('Doors timing valve jammed'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DOORS_TVC_BROKEN',		label = _('Doors timing valve cable broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },	
			
		{ id = 'IGNITION_NO_OUTPUT',	label = _('Ignition condenser burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'IGNITION_TERM_CONNECT',	label = _('Ignition terminal connection fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BOOSTER_COIL',			label = _('Booster coil fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'STARTER_WIRING',		label = _('Starter wiring fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_RELAY',			label = _('Starter relay fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_SOLENOID',		label = _('Starter solenoid fault'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'FUEL_PUMP_FAILURE',		label = _('Fuel pump defective'),	 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'INSUF_FUEL_PRES',		label = _('Fuel pressure insufficient'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CLOGGED_FUEL_STRAINER',	label = _('Fuel strainer clogged'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_VALVE_LEAK',		label = _('Fuel valve leak'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'LEFT_WING_TANK_LEAK',	label = _('Left fuel tank leak'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'RIGHT_WING_TANK_LEAK',	label = _('Right fuel tank leak'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'LEFT_TANK_PUMP_FAULT',	label = _('Left tank pump fault'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'RIGHT_TANK_PUMP_FAULT',	label = _('Right tank pump fault'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'BOOST_REG',				label = _('Boost regulator failure'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PROP_GOVERNOR',			label = _('Prop governor failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAGNETO_1',				label = _('Magneto 1 failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAGNETO_2',				label = _('Magneto 2 failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENGINE_JAM',			label = _('Engine jam'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_UNPRES',		label = _('Coolant system unpressurized'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BATTERY_OVERHEAT',		label = _('Battery overheated'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_BURNOUT',		label = _('Starter burn out'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'GENERATOR_FAULT',		label = _('Generator failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},
	]]--

	--[[
    lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", dir_correction = {elevation = math.rad(-6.0)}, argument = 208,
                                proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", dir_correction = {elevation = math.rad(-6.0)}, argument = 208,
                                proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_2", dir_correction = {elevation = math.rad(-45.0)}, argument = 190,
                        proto = lamp_prototypes.ANO_3_Kr, angle_max = math.rad(150.0), angle_min = math.rad(90.0),
                    },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_1", dir_correction = {elevation = math.rad(45.0)}, argument = 191,
                        proto = lamp_prototypes.ANO_3_Zl, angle_max = math.rad(150.0), angle_min = math.rad(90.0),
                    },
                    { -- 2 -- Tail Position Light (white)
                        typename = "collection",
                        lights = {
                            {
                                typename = "Spot", connector = "BANO_0", dir_correction = {azimuth = math.rad(180.0)}, argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                                movable = true,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 6.2,
                                movable = true,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_1", argument = 200,
                        color = {0.99, 0.11, 0.3, 0.22}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_2", argument = 201,
                        color = {0.0, 0.894, 0.6, 0.25}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_3", argument = 202,
                        color = {1.0, 0.5, 0.0, 0.25}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                }
            },
        }
    },
	]]--
	
	ViewSettings = ViewSettings,
	SnapViews	 = SnapViews,
	
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada",
	"China","Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France",
	"Georgia","German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents",
	"Iran","Iraq","Israel","Italy","Italian Social Republic","Japan","Kazakhstan","NASA","North Korea",
	"Norway","Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia",
	"South Korea","South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey",
	"UK","Ukraine","USA","USAF Aggressors","USSR","Vietnam"}


}

--SFM_add.lua (file 7 for assembly)

add_aircraft(p38)


